#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Net;

#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_StandardNullAwareConverters : BaseTest 
	{

		[SetUp]
		protected void SetUp() 
		{	
			this.BaseSetUp();
		}

		[Test]
		public void IsNull_Object_Pass()
		{
			object tmpObj;

			tmpObj = null;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));

			tmpObj = DBNull.Value;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));

			tmpObj = Int32.MinValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));

			tmpObj = DateTime.MinValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));
			
			tmpObj = Char.MinValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));
			
			tmpObj = Byte.MaxValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));
			
			tmpObj = string.Empty.ToCharArray();
			Assert.IsTrue(StNullConvert.IsNull(tmpObj));
		}

		[Test]
		public void IsNull_Object_Fail()
		{
			object tmpObj;

			tmpObj = new object();
			Assert.IsTrue(StNullConvert.IsNull(tmpObj) == false);

			tmpObj = Int32.MaxValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj) == false);

			tmpObj = DateTime.MaxValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj) == false);
			
			tmpObj = Char.MaxValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj) == false);
			
			tmpObj = Byte.MinValue;
			Assert.IsTrue(StNullConvert.IsNull(tmpObj) == false);
			
			tmpObj = "X".ToCharArray();
			Assert.IsTrue(StNullConvert.IsNull(tmpObj) == false);
		}

		[Test]
		public void IsNull_Int32_Pass()
		{
			Assert.IsTrue(StNullConvert.IsNull(Int32.MinValue));
		}

		[Test]
		public void IsNull_Int32_Fail()
		{
			Assert.IsTrue(StNullConvert.IsNull(Int32.MaxValue) == false);
		}

		[Test]
		public void IsNull_DateTime_Pass()
		{
			Assert.IsTrue(StNullConvert.IsNull(DateTime.MinValue));
		}

		[Test]
		public void IsNull_DateTime_Fail()
		{
			Assert.IsTrue(StNullConvert.IsNull(DateTime.Now) == false);
		}

		[Test]
		public void IsNull_Char_Pass()
		{
			Assert.IsTrue(StNullConvert.IsNull(Char.MinValue));
		}

		[Test]
		public void IsNull_Char_Fail()
		{
			Assert.IsTrue(StNullConvert.IsNull('A') == false);
		}

		[Test]
		public void IsNull_Byte_Pass()
		{
			Assert.IsTrue(StNullConvert.IsNull(Byte.MaxValue));
		}

		[Test]
		public void IsNull_Byte_Fail()
		{
			Assert.IsTrue(StNullConvert.IsNull(Byte.MinValue) == false);
		}

		[Test]
		public void IsNull_CharArray_Pass()
		{
			Assert.IsTrue(StNullConvert.IsNull("".ToCharArray()));
		}

		[Test]
		public void IsNull_CharArray_Fail()
		{
			Assert.IsTrue(StNullConvert.IsNull("A".ToCharArray()) == false);
		}

		[Test]
		public void IsNull_Guid_Pass()
		{
			Assert.IsTrue( StNullConvert.IsNull( Guid.Empty ) );			
		}

		[Test]
		public void IsNull_Guid_Fail()
		{
			Assert.IsTrue( !StNullConvert.IsNull( Guid.NewGuid() ) );
		}

		[Test]
		public void ToString_Object_Pass()
		{
			string tmpString = System.DateTime.Now.ToString();
			object tmpObj = tmpString;

			Assert.IsTrue(StDbNullConvert.ToString(tmpObj) == tmpString);
		}

		[Test]
		public void ToString_Object_Fail()
		{
			object tmpObj = Int32.MinValue;

			Assert.IsNull(StDbNullConvert.ToString(tmpObj));
		}

		[Test]
		public void ToInt32_Object_Pass()
		{
			Int32 tmpInt = Int32.MaxValue;
			object tmpObj = tmpInt;

			Assert.IsTrue(StDbNullConvert.ToInt32(tmpObj) == tmpInt);
		}

		[Test]
		public void ToInt32_Object_Fail()
		{
			Assert.IsTrue(StDbNullConvert.ToInt32(null) == Int32.MinValue);
		}

		[Test]
		public void ToInt32_Object_2_Pass()
		{
			Assert.AreEqual( -1, StDbNullConvert.ToInt32( System.DBNull.Value, -1 ) );
		}

		[Test]
		[ExpectedException(typeof(FormatException))]
		public void ToInt32_Object_2_Fail()
		{			
			StDbNullConvert.ToInt32( "a", 0 );
		}

		[Test]
		public void ToDateTime_Pass()
		{
			DateTime tmpDate = System.DateTime.Now;
			object tmpObj = tmpDate;

			Assert.IsTrue(StDbNullConvert.ToDateTime(tmpObj) == tmpDate);
		}

		[Test]
		public void ToDateTime_Fail()
		{
			Assert.IsTrue(StDbNullConvert.ToDateTime(null) == DateTime.MinValue);
		}

		[Test]
		public void ToIPAddress_Object_Pass()
		{
			IPAddress tmpIP = IPAddress.Broadcast;
			object tmpObj = tmpIP;

			Assert.IsTrue(StDbNullConvert.ToIPAddress(tmpObj).ToString() == tmpIP.ToString());
		}

		[Test]
		public void ToIPAddress_Object_Fail()
		{
			Assert.IsNull(StDbNullConvert.ToIPAddress(Int32.MinValue));
		}

		[Test]
		public void ToChar_Object_Pass()
		{
			char tmpChar = 'A';
			object tmpObj = tmpChar;

			Assert.IsTrue(StDbNullConvert.ToChar(tmpObj) == tmpChar);
		}

		[Test]
		public void ToChar_Object_Fail()
		{
			Assert.IsTrue(StDbNullConvert.ToChar(null) == Char.MinValue);
		}

		[Test]
		public void ToByte_Pass()
		{
			byte tmpByte = byte.MinValue;
			object tmpObj = tmpByte;

			Assert.IsTrue(StDbNullConvert.ToByte(tmpObj) == tmpByte);
		}

		[Test]
		public void ToByte_Fail()
		{
			Assert.IsTrue(StDbNullConvert.ToByte(null) == Byte.MaxValue);
		}

		[Test]
		public void ToCharArray_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();
			char[] tmpCharArray = tmpValue.ToCharArray();
			object tmpObj = tmpValue;
			Assert.IsTrue(StDbNullConvert.ToCharArray(tmpObj).Length == tmpCharArray.Length);
		}

		[Test]
		public void ToCharArray_Fail()
		{
			Assert.IsTrue(StDbNullConvert.ToCharArray(null).Length == String.Empty.ToCharArray().Length);
		}

		[Test]
		public void ToGuid_Pass()
		{
			Guid _testGuid = Guid.NewGuid();

			Assert.AreEqual( _testGuid, StDbNullConvert.ToGuid( (object)_testGuid ) );
		}

		[Test]
		public void ToGuid_Fail()
		{
			Assert.IsTrue( StDbNullConvert.ToGuid( System.DBNull.Value ) == Guid.Empty );
		}

		[Test]
		public void ToBool_Pass()
		{
			object _testValue = true;
			Assert.IsTrue( StDbNullConvert.ToBool( _testValue, false ) );
		}

		[Test]
		[ExpectedException(typeof(InvalidCastException))]
		public void ToBool_Fail()
		{
			StDbNullConvert.ToBool( String.Empty, false );
		}

		[Test]
		public void From_Object_Pass()
		{
			DateTime tmpDate = System.DateTime.Now;
			IPAddress tmpIP = IPAddress.Broadcast;

			char[] tmpCharArray = tmpDate.ToString().ToCharArray();
			object tmpObj = tmpCharArray;

			Assert.IsTrue(StDbNullConvert.From(null) == DBNull.Value);

			object tmpObjIP = tmpIP.ToString();
			Assert.IsTrue(StDbNullConvert.From(tmpIP).ToString() == tmpObjIP.ToString());

			//TODO: This needs to be coded.. CharArray's dont compare well
			//Assertion.IsTrue(StDbNullConvert.From(tmpCharArray).ToString() == tmpObj.ToString());
		}

		[Test]
		public void From_Object_Fail()
		{
			object tmpValue = System.DateTime.Now;

			Assert.IsTrue(StDbNullConvert.From(tmpValue) == tmpValue);
		}

		[Test]
		public void ToRowversion_Pass()
		{
			byte[] _test = new byte[10];

			Assert.AreEqual( _test, StDbNullConvert.ToRowversion( (object)_test ) );
		}

		[Test]
		public void ToRowversion_Fail()
		{
			Assert.IsNull( StDbNullConvert.ToRowversion( System.DBNull.Value ) );
		}

		[Test]
		public void DecimalFrom_Pass()
		{
			decimal tmpDecimal = decimal.Zero;

			Assert.IsTrue(StUiNullConvert.DecimalFrom(null, tmpDecimal) == tmpDecimal);

		}

		[Test]
		public void DecimalFrom_Fail()
		{
			decimal tmpDecimal = decimal.MaxValue;
			object tmpObj = decimal.Zero;

			Assert.IsTrue(StUiNullConvert.DecimalFrom(tmpObj, tmpDecimal) == decimal.Zero);
		}

		[Test]
		public void From_String_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();
			object tmpObj = tmpValue;

			Assert.IsTrue(StUiNullConvert.From(tmpObj) == tmpValue);
		}

		[Test]
		public void From_String_Fail()
		{
			Assert.IsTrue(StUiNullConvert.From(null) == string.Empty);
		}

		[Test]
		public void ToInt32_String_Pass()
		{
			int tmpInt = 123;
			string tmpString = "123";

			Assert.IsTrue(StUiNullConvert.ToInt32(tmpString) == tmpInt);
		}

		[Test]
		public void ToInt32_String_Fail()
		{
			string tmpString = string.Empty;

			Assert.IsTrue(StUiNullConvert.ToInt32(tmpString) == Int32.MinValue);

			tmpString = "Hello";
			Assert.IsTrue(StUiNullConvert.ToInt32(tmpString) == Int32.MinValue);


		}

		[Test]
		public void ToIPAddress_String_Pass()
		{
			IPAddress tmpIP = IPAddress.Parse(IPAddress.Broadcast.ToString());

			Assert.IsTrue(StUiNullConvert.ToIPAddress(IPAddress.Broadcast.ToString()).ToString() == tmpIP.ToString());
		}

		[Test]
		public void ToIPAddress_String_Fail()
		{
			Assert.IsNull(StUiNullConvert.ToIPAddress(string.Empty));
		}

		[Test]
		public void ToChar_String_Pass()
		{
			string tmpString = "A";

			Assert.IsTrue(StUiNullConvert.ToChar(tmpString) == 'A');
		}

		[Test]
		public void ToChar_String_Fail()
		{
			Assert.IsTrue(StUiNullConvert.ToChar(string.Empty) == char.MinValue);
		}

		[Test]
		public void ToString_String_Pass()
		{
			string tmpString = System.DateTime.Now.ToString();

			Assert.IsTrue(StUiNullConvert.ToString(tmpString, true) == tmpString);
			Assert.IsTrue(StUiNullConvert.ToString(tmpString, false) == tmpString);
		}

		[Test]
		public void ToString_String_Fail()
		{
			string tmpString = string.Empty;

			Assert.IsNull(StUiNullConvert.ToString(tmpString, true));
			Assert.IsTrue(StUiNullConvert.ToString(tmpString, false) == string.Empty);
		}

		[Test]
		public void DecimalToInt32_Pass()
		{
			decimal tmpDecimal = decimal.Zero;
			Assert.IsTrue(StUiNullConvert.DecimalToInt32(tmpDecimal) == (Int32)0);
		}

		[Test]
		[ExpectedException(typeof(OverflowException))]
		public void DecimalToInt32_Fail()
		{
			Assert.IsTrue(StUiNullConvert.DecimalToInt32(Decimal.MaxValue) == Int32.MaxValue);
		}

		[Test]
		public void DecimalToByte_Pass()
		{
			decimal tmpDecimal = decimal.Zero;
			Assert.IsTrue(StUiNullConvert.DecimalToByte(tmpDecimal) == (byte)0);
		}

		[Test]
		[ExpectedException(typeof(OverflowException))]
		public void DecimalToByte_Fail()
		{
			Assert.IsTrue(StUiNullConvert.DecimalToByte(decimal.MinValue) == byte.MinValue);
		}

		[Test]
		public void IsZeroString_Pass()
		{
			string tmpString = System.DateTime.Now.ToString();
			Assert.IsTrue(StUiNullConvert.IsZeroString(tmpString) == false);
		}

		[Test]
		public void IsZeroString_Fail()
		{
			Assert.IsTrue(StUiNullConvert.IsZeroString(null));
			Assert.IsTrue(StUiNullConvert.IsZeroString(string.Empty));
		}
	}
}
#endif
